/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 2.6.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2009,2011 COLLARD Christophe
 * copyright © 2009 BERBENNI Stephane
 * copyright © 2009,2011 Centre National de la Recherche Scientifique
 * copyright © 2009,2011 Arts et Métiers ParisTech
 * copyright © 2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2011 Laboratoire d'Etude des Microstructures et de Mécanique des Matériaux (LEM3 - CNRS)
 * copyright © 2011 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    isotropic transverse tensors-tests belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type isotropic tensors test
#endif

#if !defined(__TRANSVERSELY_ISOTROPIC_TENSORS_TEST_H)
#define __TRANSVERSELY_ISOTROPIC_TENSORS_TEST_H


#if !defined (__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__COLORS_H)
#include "colors.h"
#endif

#if !defined(__PARAMETERS_H)
#include "parameters.h"
#endif

#if !defined(__MATHS_H)
#include "MOL++/maths.h"
#endif

#if !defined(__VECTORS_H)
#include "MOL++/vectors.h"
#endif

#if !defined(__MATRIX_H)
#include "MOL++/matrix.h"
#endif

#if !defined(__TENSOR2_H)
#include "MOL++/tensors2.h"
#endif

#if !defined(___SYMTENSOR2_H)
#include "MOL++/symtensors2.h"
#endif

#if !defined(__TENSOR4_H)
#include "MOL++/tensors4.h"
#endif

#if !defined(__CONVERSION_TOOLS_H)
#include "MOL++/conversion tools.h"
#endif

#if !defined(__TRANSVERSELY_ISOTROPIC_TENSORS_H)
#include "MateriOL++/transversely isotropic tensors.h"
#endif

#if !defined(__MATERIALS_TOOLBOX_H)
#include "MateriOL++/MatOoLbox.h"
#endif

#if !defined(__WALPOLE_H)
#include "MateriOL++/walpole.h"
#endif

#include "MateriOL++/PII.h"

#if !defined(__AFFICHE_h)
#include "tests/affiche.h"
#endif

using namespace std;
using namespace mol;
using namespace materiol;


//==================================================
bool test_transversely_isotropic_tensor (int detail)
//==================================================
{
  bool result = true;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "          transversely isotropic tensor test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  long double E1 = 20.440;
  long double nu12 = 0.1027;
  long double E3 = 11.306;
  long double nu31 = 0.1798;
  long double G13 = 1.5851;
  long double C11 = E1 * ( -E3 + E1 * power (nu31,2)) / ((1. + nu12) * (E3 * (-1  + nu12) + 2. * E1 * power (nu31,2)));
  long double C66 = G13;
  long double C13 = ( E1 * E3 * nu31) / ( E3 - E3 * nu12 - 2. * E1 * power (nu31,2));
  long double C12 = - E1 * ( E3 * nu12 + E1 * power (nu31,2)) / ((1. + nu12) * (E3 * (-1  + nu12) + 2. * E1 * power (nu31,2))) ;
  
  long double C33 = power (E3,2) * (-1 + nu12) / ( E3 * (-1 + nu12) + 2 * E1 * power (nu31,2));

  tensor4<long double> C(3);
  C(1,1,1,1) = C(2,2,2,2) = C11;
  C(3,3,3,3) = C33;
  C(2,3,2,3) = C(2,3,3,2) = C(3,2,2,3) = C(3,2,3,2) = C(1,3,1,3) = C(1,3,3,1) = C(3,1,1,3) = C(3,1,3,1)= C66;
  C(1,2,1,2) = C(1,2,2,1) = C(2,1,1,2) = C(2,1,2,1) = 0.5 * (C11 - C12);
  C(1,1,2,2) = C(2,2,1,1) = C12;
  C(1,1,3,3) = C(3,3,1,1) = C(2,2,3,3) = C(3,3,2,2) = C13;

  C11 = 30734.2;
  C33 = 28634.5;
  C66 = 8372.87;
  C12 = 7059.59;
  C13 = 9558.05;
  C(1,1,1,1) = C(2,2,2,2) = C11;
  C(3,3,3,3) = C33;
  C(2,3,2,3) = C(2,3,3,2) = C(3,2,2,3) = C(3,2,3,2) = C(1,3,1,3) = C(1,3,3,1) = C(3,1,1,3) = C(3,1,3,1)= C66;
  C(1,2,1,2) = C(1,2,2,1) = C(2,1,1,2) = C(2,1,2,1) = 0.5 * (C11 - C12);
  C(1,1,2,2) = C(2,2,1,1) = C12;
  C(1,1,3,3) = C(3,3,1,1) = C(2,2,3,3) = C(3,3,2,2) = C13;
  transversely_isotropic_tensor<long double> Ciso_tr (C11, C33, C66, C12, C13);

  vector<long double> v(5);
  v[1] = C11;
  v[2] = C33;
  v[3] = C66;
  v[4] = C12;
  v[5] = C13;
  transversely_isotropic_tensor<long double> Ciso_tr2 (v);

  if (detail) affiche ("constructor", Ciso_tr==C && Ciso_tr==Ciso_tr2);
  else result *=  (Ciso_tr==C && Ciso_tr==Ciso_tr2);

  if (detail) affiche ("elastic constants", v == Ciso_tr.elastic_constants());
  else result *= (v == Ciso_tr.elastic_constants());

  long double phi1, Phi, phi2;
  phi1 = phi2 = 0;
  Phi = 5.*pi()/7.;
  tensor4<long double> Cnew = Ciso_tr.change_basis (phi1, Phi, phi2);
  //  cout << symtensor2matrix (Cnew);
  //  cout << walpole::symtensor2matrix (Cnew);

  matrix<long double> P = local2global_basis (phi1, Phi, phi2);
  tensor4<long double> T = change_basis (P,C);
  //  cout << symtensor2matrix (T);

  if (detail) affiche ("inv", (Ciso_tr || Ciso_tr.inv()) == Id4s<long double>(3));
  else result *= ( (Ciso_tr || Ciso_tr.inv()) == Id4s<long double>(3));

  if (detail) affiche ("change basis", Cnew == T);
  else result *= (Cnew == T);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "          transversely isotropic tensor test passed" << reset;
  else cout << red << "          transversely isotropic tensor test failed" << reset;
  cout << "============================================================== \n";

  return result;  
}


#endif
